/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryTools {
    public static int getInventorySize(BlockEntity tileEntity) {
        if (tileEntity == null) {
            return 0;
        }
        return tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(IItemHandler::getSlots).orElse(0);
    }

    public static boolean isInventory(BlockEntity te) {
        return te != null && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent();
    }

    public static Stream<ItemStack> getItems(BlockEntity tileEntity, Predicate<ItemStack> predicate) {
        Stream.Builder builder = Stream.builder();
        if (tileEntity != null) {
            tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack itemStack = handler.getStackInSlot(i);
                    if (itemStack.m_41619_() || !predicate.test(itemStack)) continue;
                    builder.add(itemStack);
                }
            });
        }
        return builder.build();
    }

    @Nonnull
    public static ItemStack getFirstMatchingItem(BlockEntity tileEntity, Predicate<ItemStack> predicate) {
        if (tileEntity != null) {
            return tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack itemStack = handler.getStackInSlot(i);
                    if (itemStack.m_41619_() || !predicate.test(itemStack)) continue;
                    return itemStack;
                }
                return ItemStack.f_41583_;
            }).orElse(ItemStack.f_41583_);
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public static ItemStack insertItem(Level world, BlockPos pos, Direction direction, @Nonnull ItemStack s) {
        BlockEntity te = world.m_7702_(direction == null ? pos : pos.m_142300_(direction));
        if (te != null) {
            Direction opposite = direction == null ? null : direction.m_122424_();
            return te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, opposite).map(handler -> ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)s, (boolean)false)).orElse(ItemStack.f_41583_);
        }
        return s;
    }

    public static boolean isItemStackConsideredEqual(ItemStack result, ItemStack itemstack1) {
        return !itemstack1.m_41619_() && itemstack1.m_41720_() == result.m_41720_() && result.m_41773_() == itemstack1.m_41773_() && ItemStack.m_41658_((ItemStack)result, (ItemStack)itemstack1);
    }

    @Nonnull
    public static ItemStack insertItemRanged(IItemHandler dest, @Nonnull ItemStack stack, int start, int stop, boolean simulate) {
        if (dest == null || stack.m_41619_()) {
            return stack;
        }
        for (int i = start; i < stop; ++i) {
            if (!(stack = dest.insertItem(i, stack, simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }
}

